<html>
<head>
<style>
body {
  width: 300px;
}

#header {
  border: 1px solid;
  overflow: hidden;
}

#header>div {
  float: left;
  width: 50%;
  line-height: 100px;
  text-align: center;
}

#foot {
  border: 1px solid;
}

#header p {
  margin: 0;
}

#header #page-number {
  border-left: 1px solid;
  width: calc(50% - 1px);
}

#page-number:after {
  content: "All pages";
}

@media print {
  .pageBreak {
    page-break-before: always;
    padding-bottom: 120px;
  }
  #content {
    padding-top: 120px;
  }
  #header {
    display: block;
    position: fixed;
    top: 0pt;
    left: 0pt;
    right: 0pt;
  }
  #page-number:after {
    content: "Page " counter(page);
    counter-increment: page;
  }
  #foot {
    display: block;
    position: fixed;
    bottom: 0pt;
  }
}
</style>
</head>
<body>
<div id="header">
  <div id="header-title">
    <p>Header title</p>
  </div>
  <div id="page-number"></div>
</div>
<div id="content">
  First page with some data.
  <div class="pageBreak"></div>
  Second page with some data.
  <div class="pageBreak"></div>
  Third page with some data.
  <div class="pageBreak"></div>
  Fourth page with some data.
  <div class="pageBreak"></div>
</div>
<div id="foot">
  Other info.
</div>
</body>
</html>