function toggleRow(event) {
  var rowId = event.currentTarget.id;
  var children = document.querySelectorAll("[data-parent=" + rowId + "]")
  children.forEach(function(row) {
    if (row.classList.contains("expanded")) {
      row.classList.remove("expanded");
    } else {
      row.classList.add("expanded");
    }
  });
}

var rows = document.querySelectorAll(".parent-row")
rows.forEach(function(row) {
  row.addEventListener("click", toggleRow);
});

.tree-table .parent-row:hover {
  cursor: pointer;
}

.tree-table [data-parent] td:first-child {
  padding-left: 10px;
}

.tree-table [data-parent] {
  display: none;
}

.tree-table [data-parent].expanded {
  display: table-row;
}

<table class="tree-table">
  <tbody>
    <tr id="row-1" class="parent-row"><td>folder1</td></tr>
    <tr data-parent="row-1"><td>SF1</td></tr>
    <tr id="row-1-1" class="parent-row" data-parent="row-1"><td>SF2</td></tr>
    <tr data-parent="row-1-1"><td>SF1 SF1</td></tr>
    <tr id="row-2" class="parent-row"><td>folder2</td></tr>
    <tr data-parent="row-2"><td>SFF1</td></tr>
    <tr data-parent="row-2"><td>SFF2</td></tr>
    <tr data-parent="row-2"><td>SFF3</td></tr>
  </tbody>
</table>