const params = new URLSearchParams(location.search);
const priceFormatter = new Intl.NumberFormat(undefined, {
	minimumFractionDigits: 2,
	maximumFractionDigits: 2
});

function onlyNumberKey(evt) {
	try {
		// Only ASCII character in that range is allowed
		let ASCIICode = (evt.which) ? evt.which : evt.keyCode;
		if ((ASCIICode > 31) && (ASCIICode < 48 || ASCIICode > 57)) {
			return false;
		} else {
			return true;
		}
	} catch (e) {
		console.log(e);
	}
}

function feedback(message) {
	let x = document.getElementById('snackbar');

	if (message.startsWith("S")) {
		x.style.backgroundColor = 'var(--bs-success)';
	} else if (message.startsWith("R")) {
		x.style.backgroundColor = 'var(--bs-orange)';
	} else {
		x.style.backgroundColor = 'var(--bs-danger)';
	}
	x.innerText = message;
	x.classList.add("show");
	setTimeout(function () { x.classList.remove("show"); }, 3000)
}

let navHome = document.getElementById("nav-home");
let navOrderHistory = document.getElementById("nav-orderHistory");
let navQuickOrder = document.getElementById("nav-quickOrder");
let href = location.pathname.split("/");

if (href[href.length - 1].startsWith("orderHistory")) {
	navHome.classList.remove("active");
	navOrderHistory.classList.add("active");
	navQuickOrder.classList.remove("active");
} else if (href[href.length - 1].startsWith("quickOrder")) {
	navHome.classList.remove("active");
	navOrderHistory.classList.remove("active");
	navQuickOrder.classList.add("active");
} else {
	navHome.classList.add("active");
	navOrderHistory.classList.remove("active");
	navQuickOrder.classList.remove("active");
}