<%Response.expires = -1 %>
<!-- #include file="../../dealerconfig\docglobaladdress.asp" -->
<!-- #include file="../security.inc.asp" -->
<!-- #include file="../../adovbs.inc" -->

<!DOCTYPE html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0,user-scalable=no">
<link href="../../font-awesome/css/font-awesome.min.css" rel="stylesheet" id="font-awesome-css">
<link rel="stylesheet" type="text/css" href="bootstrap/dist/css/bootstrap.css">
<link rel="stylesheet" type="text/css" href="CSS/catalogue.css">
<title><%= gline0 %>'s Catalogue</title>
<%
	search = Trim(Request("search"))
	sortBy = Trim(Request("sortBy"))

	If Not vartype(sys_cus_portal_searchByDept) = vbBoolean Then sys_cus_portal_searchByDept = false ' Default
	If sys_cus_portal_searchByDept Then showDept = "visible"
%>
</head>

<body>
	<!-- #include file="header.asp" -->

	<!-- Catalogue -->
	<div class="container">
		<div class="row">

			<!-- Filter Components -->
			<div role="filter" id="filter-container" class="col-md-4 col-lg-3 component">
				<!-- Filter -->
				<div>
					FILTER&nbsp;&nbsp;<i class="fa fa-filter" aria-hidden="true"></i>
				</div>
				<div id="filter-group" class="filter-type visible">
					&nbsp;Group
					<div class="list-group" id="filter-group-container">
						<!-- Groups -->
					</div>
				</div>
				<div id="filter-cat" class="filter-type visible">
					&nbsp;Category
					<div class="list-group" id="filter-cat-container">
						<!-- Categories -->
					</div>
				</div>
				<div id="filter-dept" class="filter-type <%= showDept %>">
					&nbsp;Dept
					<div class="list-group" id="filter-dept-container">
						<!-- Depts -->
					</div>
				</div>

				<hr>

				<!-- Sort By -->
				<div>
					&nbsp;Sort By&nbsp;&nbsp;<i class="fa fa-sort" aria-hidden="true"></i>
				</div>
				<div>
					<div class="list-group">
						<label class="list-group-item">
					    	<input class="form-check-input me-1 sortBy" type="radio" name="sortBy" id="alphaAsc" value="0" onchange="updateItemData()" <% If sortBy = "0" OR sortBy = "" Then Response.Write "checked" %>>
					    	<label for="alphaAsc">
						    	Alphabetical (A-Z)&nbsp;<i class="fa fa-sort-alpha-asc" aria-hidden="true"></i>
					    	</label>
						</label>
						<label class="list-group-item">
					    	<input class="form-check-input me-1 sortBy" type="radio" name="sortBy" id="alphaDesc" value="1" onchange="updateItemData()" <% If sortBy = "1" Then Response.Write "checked" %>>
					    	<label for="alphaDesc">
						    	Alphabetical (Z-A)&nbsp;<i class="fa fa-sort-alpha-desc" aria-hidden="true"></i>
					    	</label>
						</label>
						<label class="list-group-item">
					    	<input class="form-check-input me-1 sortBy" type="radio" name="sortBy" id="priceAsc" value="2" onchange="updateItemData()" <% If sortBy = "2" Then Response.Write "checked" %>>
					    	<label for="priceAsc">
						    	Price low to high&nbsp;<i class="fa fa-sort-numeric-asc" aria-hidden="true"></i>
					    	</label>
					    	
						</label>
						<label class="list-group-item">
					    	<input class="form-check-input me-1 sortBy" type="radio" name="sortBy" id="priceDesc" value="3" onchange="updateItemData()" <% If sortBy = "3" Then Response.Write "checked" %>>
					    	<label for="priceDesc">
						    	Price high to low&nbsp;<i class="fa fa-sort-numeric-desc" aria-hidden="true"></i>
					    	</label>
						</label>
					</div>
				</div>

				<div class="row filter-btn">
					<input type="button" id="filter-clear" value="Clear" class="btn btn-outline-secondary" onclick="clearFilter()">
				</div>
			</div>

			<!-- Item Components -->
			<div class="col-md-8 col-lg-9 px-0 px-md-2">
				<!-- Search Bar -->
				<div role="search" class="row component searchBar">
		        	<div class="col-11 g-0">
		        		<input class="form-control" type="search" name="search" id="search" placeholder="Search" aria-label="Search" value="<%= Server.HTMLENCODE(search) %>" onkeypress="submitSearch(event)">
		        	</div>
		        	<label for="searchBtn" class="col-1 g-0 searchBtn">
		        		<i class="fa fa-search" aria-hidden="true"></i>
		        	</label>
		        	<input type="button" id="searchBtn" onclick="updateItemData()" hidden>
		        </div>

				<!-- Item List -->
				<div class="component" id="itemList">
					<% If sys_cus_portal_display = "GRID" Then %>
						<div class="row row-cols-2 row-cols-lg-3 row-cols-xl-4 g-2 itemList" id="item-card-container">
							<!-- Item Grid -->
						</div>
					<% ElseIf sys_cus_portal_display = "LIST" Then %>
						<div class="row g-2 itemList" id="item-card-container">
							<!-- Item List -->
						</div>
					<% End If %>
					<!-- Pagination -->
					<nav aria-label="Page navigation">
					  	<ul class="pagination" id="pagination-container">
					    	<!-- Pagination buttons -->
					  	</ul>
					</nav>
				</div>

				<!-- Error -->
				<div id="error" class="error component hide">
					<h2 id="errorHeader"></h2>
					<p id="errorMessage"></p>
					<i class="fa fa-search" aria-hidden="true" style="font-size: 50px; color: #999999;"></i>
				</div>

				<!-- Loading/Spinning -->
				<div class="d-flex component hide" id="loading">
					<div class="spinner-border text-secondary" role="status">
						<span class="visually-hidden">Loading...</span>
					</div>
				</div>

			</div>
		</div>
	</div>

	<!-- #include file="cart.asp" -->
</body>
<script src="JS/catalogue.js"></script>
<script src="bootstrap/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
</html>
