const params = new URLSearchParams(location.search);
const priceFormatter = new Intl.NumberFormat(undefined, {
	minimumFractionDigits: 2,
	maximumFractionDigits: 2
});

function onlyNumberKey(evt) {
	try {
		// Only ASCII character in that range is allowed
		let ASCIICode = (evt.which) ? evt.which : evt.keyCode;
		if ((ASCIICode > 31) && (ASCIICode < 48 || ASCIICode > 57)) {
			return false;
		} else {
			return true;
		}
	} catch (e) {
		console.log(e);
	}
}

function feedback(message) {
	let x = document.getElementById('snackbar');

	if (message.startsWith("S")) {
		x.style.backgroundColor = 'var(--bs-success)';
	} else if (message.startsWith("R")) {
		x.style.backgroundColor = 'var(--bs-orange)';
	} else {
		x.style.backgroundColor = 'var(--bs-danger)';
	}
	x.innerText = message;
	x.classList.add("show");
	setTimeout(function () { x.classList.remove("show"); }, 3000)
}

function toggleModal() {
	try {
		document.getElementById('modal').classList.toggle("hide");
		document.getElementById('loading').classList.remove("hide");
		document.getElementById('success').classList.add("hide");
		document.getElementById('failed').classList.add("hide");
	} catch (error) {
		console.log(error);
	}
}

function toggleSuccess(message) {
	try {
		document.getElementById('loading').classList.add("hide");
		document.getElementById('success').classList.remove("hide");
		document.getElementById('failed').classList.add("hide");
		document.getElementById('success-msg').innerHTML = message;
	} catch (error) {
		console.log(error);
	}
}

function toggleFailed(message) {
	try {
		document.getElementById('loading').classList.add("hide");
		document.getElementById('success').classList.add("hide");
		document.getElementById('failed').classList.remove("hide");
		document.getElementById('failed-msg').innerHTML = message;
	} catch (error) {
		console.log(error);
	}
}

function enableBackToTop() {
	try {
		if (document.body.scrollTop > 125 || document.documentElement.scrollTop > 125) {
			document.getElementById("backToTop").style.display = "block";
		} else {
			document.getElementById("backToTop").style.display = "none";
		}
	} catch (error) {
		console.log(error);
	}
}

function backToTop() {
	try {
		document.body.scrollTop = 0; // For Safari
  		document.documentElement.scrollTop = 0; // For Chrome, Firefox, IE and Opera
	} catch (error) {
		console.log(error);
	}
}

let navStockTake = document.getElementById("nav-stockTake");
let navMarkReceived = document.getElementById("nav-markReceived");
let navStockRequest = document.getElementById("nav-stockRequest");
let navStockReturn = document.getElementById("nav-stockReturn");
let moduleName = document.getElementById("moduleName");
let navBtn = document.getElementById("navBtn");
let href = location.pathname.split("/");

// Set navBtn icon
if (params.has("moduleName")) {
	navBtn.innerHTML = `<i class="fa fa-chevron-left" aria-hidden="true" style="font-size: 24px; width: 32px;"></i>`;
} else {
	navBtn.innerHTML = `<i class="fa fa-home" aria-hidden="true" style="font-size: 32px; width: 32px;"></i>`;
}

// Set active navItem and navBtn link
if (href[href.length - 1].startsWith("markReceived")) {
	navStockTake.classList.remove("active");
	navMarkReceived.classList.add("active");
	navStockRequest.classList.remove("active");
	navStockReturn.classList.remove("active");
	moduleName.innerHTML = "MARK RECEIVED";

	navBtn.setAttribute("onclick", "history.back()");
} else if (href[href.length - 1].startsWith("stockRequest")) {
	navStockTake.classList.remove("active");
	navMarkReceived.classList.remove("active");
	navStockRequest.classList.add("active");
	navStockReturn.classList.remove("active");
	moduleName.innerHTML = "STOCK REQUEST";

	navBtn.setAttribute("onclick", "history.back()");
} else if (href[href.length - 1].startsWith("stockReturn")) {
	navStockTake.classList.remove("active");
	navMarkReceived.classList.remove("active");
	navStockRequest.classList.remove("active");
	navStockReturn.classList.add("active");
	moduleName.innerHTML = "STOCK RETURN";

	navBtn.setAttribute("onclick", "history.back()");
} else {
	navStockTake.classList.add("active");
	navMarkReceived.classList.remove("active");
	navStockRequest.classList.remove("active");
	navStockReturn.classList.remove("active");
	moduleName.innerHTML = "STOCK TAKE";

	if (params.get("moduleName") == "start") {
		navBtn.setAttribute("onclick", "location.search = ''");
	} else {
		navBtn.setAttribute("onclick", "location.search = 'moduleName=start&batchNo=" + params.get("batchNo") + "'");
	}
}

if (!params.has("moduleName")) {
	navBtn.setAttribute("onclick", "location.href = 'main.asp?';");
}